<?php
/**
 * <pre>
 * Advanced Tags & Prefixes
 * IP.Board v3.2.2
 * Last Updated: 12 September, 2011
 * </pre>
 *
 * @author 		Ryan Hoerr
 * @copyright	(c) 2011 Ryan Hoerr / Sublime Development
 * @link		http://www.sublimism.com
 * @version		2.0.5 (Revision 20007)
 */

/**
 * ACP templates for the Prefixes module
 */
 
class cp_skin_prefixes extends output {

public function __destruct() { }

/**
 * Main index: show all prefixes
 */
public function prefixMainScreen( $rows, $dropdown, $warnings = array() ) {
$IPBHTML = "";
//--starthtml--//

if( count($warnings) ) {
	$warnings = implode( '<br />', $warnings );
	$IPBHTML .= <<<HTML
<div class="warning">
	<strong>{$this->lang->words['pre_legacy_warn']}</strong><br />
	{$warnings}
</div><br />
HTML;
}

$IPBHTML .= <<<HTML
<div class='section_title'>
	<h2>{$this->lang->words['pre_manage']}</h2>
	<div class='ipsActionBar clearfix'>
		<ul>
			<li class='ipsActionButton'>
				<a href='{$this->settings['base_url']}{$this->form_code}&amp;do=addnew'>
					<img src='{$this->settings['skin_acp_url']}/_newimages/icons/add.png' alt='' />
					{$this->lang->words['pre_add_new']}
				</a>
			</li>
		</ul>
	</div>
</div>

<div class='acp-box'>
	<h3>{$this->lang->words['pre_prefixes']}</h3>
	<table class='ipsTable'>
		<tr>
			<th>{$this->lang->words['pre_title']}</th>
			<th>{$this->lang->words['pre_preview']}</th>
			<th>{$this->lang->words['pre_groups']}</th>
			<th>{$this->lang->words['pre_forums']}</th>
			<th style="width: 60px">{$this->lang->words['pre_options']}</th>
		</tr>
HTML;
if(count($rows) > 0) {
	foreach( $rows as $r ) {
		$groups		= !empty( $r['prefix_groups'] ) ? count( explode( ',', $r['prefix_groups'] ) ) : 0;
		$preview	= $r['prefix_pre'] . ($r['prefix_showtitle'] ? $r['prefix_title'] : '') . $r['prefix_post'];
		
		$IPBHTML .= <<<HTML
		<tr class='ipsControlRow'>
			<td><span class='larger_text'><a href='{$this->settings['base_url']}{$this->form_code}&amp;do=edit&amp;p={$r['prefix_id']}'>{$r['prefix_title']}</a></span></td>
			<td>{$preview}</td>
			<td>{$groups}</td>
			<td>{$r['forums']}</td>
			<td nowrap='nowrap'>
				<ul class='ipsControlStrip' id='menu{$r['prefix_id']}_menucontent'>
					<li class='i_edit'><a href='{$this->settings['base_url']}{$this->form_code}&amp;do=edit&amp;p={$r['prefix_id']}'>{$this->lang->words['edit']}</a></li>
					<li class='i_delete'><a href='{$this->settings['base_url']}{$this->form_code}&amp;do=delete&amp;p={$r['prefix_id']}' onclick='return confirm("{$this->lang->words['pre_delete_confirm']}")'>{$this->lang->words['pre_remove']}</a></li>
				</ul>
			</td>
		</tr>
HTML;
	}
}
else
	$IPBHTML .= <<<HTML
		<tr>
			<td colspan='4'>
				{$this->lang->words['pre_none_found']} 
				<a href="{$this->settings['base_url']}{$this->form_code}&amp;do=addnew" class='mini_button'>{$this->lang->words['pre_add_new']}</a>
			</td>
		</tr>
HTML;

$IPBHTML .= <<<HTML
	</table>
</div>
HTML;

if( count($dropdown) > 0 ) {
	$form['find']		= $this->registry->output->formInput( 'find' );
	$form['prefixes']	= $this->registry->output->formDropdown( "replace", $dropdown );

	if( $this->settings['sql_driver'] == 'mysql' )
		$IPBHTML .= <<<HTML
	<br /><br />
	<form id="theAdminForm" name="theAdminForm" method="post" action="{$this->settings['base_url']}{$this->form_code}">
		<input type='hidden' name='do' value='searchAndReplace' />
		<input type='hidden' name='_admin_auth_key' value='{$this->registry->adminFunctions->getSecurityKey()}' />

		<div class="acp-box">
			<h3>{$this->lang->words['pre_snr']}</h3>
			<table class="ipsTable double_pad">
				<tr>
					<td colspan="2">
						{$this->lang->words['pre_snr_desc']}
					</td>
				</tr>
				<tr>
					<td class='field_title'><strong class='title'>{$this->lang->words['pre_snr_search']}</strong></td>
					<td class='field_field'>
						{$form['find']}<br />
						<span class="desctext">{$this->lang->words['pre_snr_search_desc']}</span>
					</td>
				</tr>
				<tr>
					<td class='field_title'><strong class='title'>{$this->lang->words['pre_snr_replace']}</strong></td>
					<td class='field_field'>
						{$form['prefixes']}
					</td>
				</tr>
			</table>
			<div class="acp-actionbar">
				<input type="submit" accesskey="s" class="button" value="{$this->lang->words['pre_snr_submit']}" />
			</div>
		</div>
	</form>
HTML;
}

$IPBHTML .= <<<HTML
<div id="footer">
	{$this->lang->words['pre_app_title']} v2.0.5 
	&copy; 2011 Ryan Hoerr / <a href="http://www.sublimism.com" target="_blank">Sublime Development</a> &nbsp; | &nbsp; 
	<a href="http://community.invisionpower.com/topic/315335-download-topic-prefixes/page__view__getlastpost" target="_blank">Get Support</a>
</div>
HTML;

//--endhtml--//
return $IPBHTML;
}

/**
 * Prefix create/edit form
 */
public function prefixEditForm( $data = array() ) {

/**
 * Get forum list
 */
	require_once( IPSLib::getAppDir( 'forums' ) .'/sources/classes/forums/class_forums.php' );
	require_once( IPSLib::getAppDir( 'forums' ) .'/sources/classes/forums/admin_forum_functions.php' );

	$aff = new admin_forum_functions( $this->registry );
	$aff->forumsInit();
	$forums = $aff->adForumsForumList(1);

/**
 * Prepare form values
 */
	if( count($data) > 0 )
	{
		$type = 'doEdit';
		$title = sprintf( $this->lang->words['pre_editing'], $data['prefix_title'] );
	}
	else
	{
		$type = 'doAdd';
		$title = $this->lang->words['pre_add_new'];
	}

	$data['prefix_pre']			= isset( $data['prefix_pre'] ) ? str_replace("'","\'",$data['prefix_pre']) : str_replace("'","\'",'<span class="ipsBadge" style="background:red;">');
	$data['prefix_post']		= isset( $data['prefix_post'] ) ? str_replace("'","\'",$data['prefix_post']) : "</span>";
	$data['prefix_showtitle']	= isset( $data['prefix_showtitle'] ) ? !$data['prefix_showtitle'] : 0;

	$form				= array();
	$form['title']		= $this->registry->output->formInput( "title", $data['prefix_title'], '', 50, 'text', 'onkeyup="updPreview()"', '', 255 );
	$form['prefix']		= $this->registry->output->formInput( "pre", $data['prefix_pre'], '', 50, 'text', 'onkeyup="updPreview()"', '', 255 );
	$form['suffix']		= $this->registry->output->formInput( "post", $data['prefix_post'], '', 50, 'text', 'onkeyup="updPreview()"', '', 255 );
	$form['showtitle']	= $this->registry->output->formYesNo( "showtitle", $data['prefix_showtitle'], '', array( 'yes' => 'onfocus="updPreview()" onblur="updPreview()"','no' => 'onfocus="updPreview()" onblur="updPreview()"' ) );
	$form['groups']		= $this->registry->output->generateGroupDropdown( "groups[]", explode( ",", $data['prefix_groups'] ), true );
	$form['forums']		= $this->registry->output->formMultiDropdown( "forums[]", $forums, $data['forums'] );

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<HTML
<div class='section_title'>
	<h2>{$title}</h2>
</div>

<form action='{$this->settings['base_url']}{$this->form_code}' method='post' name='theAdminForm'  id='theAdminForm'>
	<input type='hidden' name='do' value='{$type}' />
	<input type='hidden' name='_admin_auth_key' value='{$this->registry->adminFunctions->getSecurityKey()}' />
	<input type='hidden' name='prefix_id' value='${data['prefix_id']}' />
	
	<div class='acp-box'>
		<h3>{$this->lang->words['pre_settings']}</h3>
		<table class="ipsTable double_pad">
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_prefix_title']}</strong></td>
				<td class='field_field'>
					{$form['title']}<br />
					<span class="desctext">{$this->lang->words['pre_prefix_desc']}</span><br />
					{$this->lang->words['pre_preview']}: <div id="prefix_preview" style="display:inline">&nbsp;</div>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_format_pre']}</strong></td>
				<td class='field_field'>
					{$form['prefix']}<br />
					<span class="desctext">{$this->lang->words['pre_format_pre_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_format_post']}</strong></td>
				<td class='field_field'>
					{$form['suffix']}<br />
					<span class="desctext">{$this->lang->words['pre_format_post_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_groups']}</strong></td>
				<td class='field_field'>
					{$form['groups']}<br />
					<span class="desctext">{$this->lang->words['pre_groups_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_forums']}</strong></td>
				<td class='field_field'>
					{$form['forums']}<br />
					<span class="desctext">{$this->lang->words['pre_forums_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_showtitle']}</strong></td>
				<td class='field_field'>
					{$form['showtitle']}<br />
					<span class="desctext">{$this->lang->words['pre_showtitle_desc']}</span>
				</td>
			</tr>
		</table>
		<div class='acp-actionbar'>
			<input type='submit' value='{$this->lang->words['pre_submit']}' class='button' accesskey='s'>
		</div>
	</div>
</form>
<script type="text/javascript">
function updPreview() { setTimeout("$('prefix_preview').innerHTML=$('pre').value+($('showtitle_yes').checked ? '' : $('title').value)+$('post').value;", 50) }
updPreview();
</script>
HTML;

//--endhtml--//
return $IPBHTML;
}

}
